/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.entities.instances;

import minecrafttransportsimulator.entities.instances.AEntityCrafter;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;

public class EntityBrewer
extends AEntityCrafter {
    private static final int[] BOTTLE_ITEM_SLOTS = new int[]{1, 2, 3};
    private static final int MODIFIER_ITEM_SLOT = 4;
    public static final String BREWER_FUEL_NAME = "brewing_stand";

    public EntityBrewer(AWrapperWorld world, IWrapperNBT data, JSONPart.JSONPartInteractable definition) {
        super(world, data, 5, definition, BOTTLE_ITEM_SLOTS, BOTTLE_ITEM_SLOTS);
    }

    @Override
    protected IWrapperItemStack getResultForSlot(int index) {
        return this.getStack(index).getBrewedItem(this.getStack(4));
    }

    @Override
    public String getFuelName() {
        return BREWER_FUEL_NAME;
    }

    @Override
    protected int getFuelTime(IWrapperItemStack stack) {
        return stack.isBrewingFuel() ? 8000 : 0;
    }

    @Override
    protected int getTimeForItem(IWrapperItemStack stack) {
        return 400;
    }

    @Override
    protected void performPostCraftingOperations() {
        this.removeFromSlot(4, 1);
    }

    @Override
    public boolean isStackValid(IWrapperItemStack stackToCheck, int index) {
        for (int slot = 0; slot < BOTTLE_ITEM_SLOTS.length; ++slot) {
            if (BOTTLE_ITEM_SLOTS[slot] != index) continue;
            return stackToCheck.isBrewingVessel() && this.getStack(index).isEmpty();
        }
        if (index == 4) {
            return stackToCheck.isBrewingModifier();
        }
        return super.isStackValid(stackToCheck, index);
    }
}

